#include <amxmisc>
#include <cstrike>
#include <fun>

#define PLUGIN_NAME	"JailBreak Shop"
#define PLUGIN_VERSION	"1.0"
#define PLUGIN_AUTHOR	"JoRoPiTo"

new const g_models[][] = { "gign", "gsg9", "sas", "urban" }
new gmsgShowMenu 
new g_Player[33]

public plugin_init()
{
	register_plugin(PLUGIN_NAME, PLUGIN_VERSION, PLUGIN_AUTHOR)
	register_cvar("jbshop", PLUGIN_VERSION, FCVAR_SERVER|FCVAR_SPONLY)

	register_clcmd("say /shop", "shop_cmd")
	register_clcmd("say_team /shop", "shop_cmd")

	register_logevent("round_start", 2, "0=World triggered", "1=Round_Start")
	register_logevent("round_end", 2, "1=Round_End")
	register_logevent("round_end", 2, "0=World triggered", "1&Restart_Round_")
	register_logevent("round_end", 2, "0=World triggered", "1=Game_Commencing")

	gmsgShowMenu = get_user_msgid("ShowMenu")
}

public round_end()
{
	message_begin(MSG_BROADCAST, gmsgShowMenu)
	write_short(0)
	write_char(-1)
	write_byte(0)
	write_string("")
	message_end()
}

public round_start()
{
	for(new i = 1; i <= get_maxplayers(); i++)
	{
		g_Player[i] = 0
	}
}

public shop_cmd(id)
{
	static menu, info[128]

	if(!is_user_alive(id) || g_Player[id] || get_user_team(id) != 1)
		return PLUGIN_HANDLED


	formatex(info, charsmax(info), "JailBreak Shop Menu^n(you got 50%% chance you get a item and if you dont get it you will die)")
	menu = menu_create(info, "shop_choice")

	formatex(info, charsmax(info), "Pistol (glock)")
	menu_additem(menu, info, "1", 0, -1)

	formatex(info, charsmax(info), "Freeday")
	menu_additem(menu, info, "2", 0, -1)

	formatex(info, charsmax(info), "Look like a Guard")
	menu_additem(menu, info, "3", 0, -1)

	menu_display(id, menu)

	return PLUGIN_HANDLED
}

public shop_choice(id, menu, item)
{
	if(item == MENU_EXIT)
	{
		menu_destroy(menu)
		return PLUGIN_HANDLED
	}

	static dst[32], data[5], access, callback
	menu_item_getinfo(menu, item, access, data, charsmax(data), dst, charsmax(dst), callback)
	menu_destroy(menu)

	g_Player[id] = 1
	if(random_num(0, 1))
	{
		client_print(id, print_center, "You've lost your chance")
		user_kill(id)
		return PLUGIN_HANDLED
	}

	switch(data[0])
	{
		case '1':
		{
			client_print(id, print_center, "You win glock pistol")
			give_item(id, "weapon_glock")
		}
		case '2':
		{
			get_user_name(id, dst, charsmax(dst))
			set_hudmessage(0, 50, 255, -1.0, 0.55, 0, 0.02, 5.0, 0.01, 0.01)
			show_hudmessage(0, "%s get's freeday!!", dst)
		}
		case '3':
		{
			client_print(id, print_center, "Now you look like a guard!!")
			cs_set_user_model(id, g_models[random_num(0, 3)])
		}
	}
	return PLUGIN_HANDLED
}

